/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.data;

import java.util.Comparator;
import java.util.function.Function;
import net.createmod.catnip.data.Pair;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class IntAttached<V>
extends Pair<Integer, V> {
    protected IntAttached(Integer first, V second) {
        super(first, second);
    }

    public static <V> IntAttached<V> with(int number, V value) {
        return new IntAttached<V>(number, value);
    }

    public static <V> IntAttached<V> withZero(V value) {
        return new IntAttached<V>(0, value);
    }

    public boolean isZero() {
        return (Integer)this.first == 0;
    }

    public boolean exceeds(int value) {
        return (Integer)this.first > value;
    }

    public boolean isOrBelowZero() {
        return (Integer)this.first <= 0;
    }

    public void increment() {
        Integer n = (Integer)this.first;
        this.first = (Integer)this.first + 1;
    }

    public void decrement() {
        Integer n = (Integer)this.first;
        this.first = (Integer)this.first - 1;
    }

    public V getValue() {
        return (V)this.getSecond();
    }

    public class_2487 serializeNBT(Function<V, class_2487> serializer) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("Item", (class_2520)serializer.apply(this.getValue()));
        nbt.method_10569("Location", ((Integer)this.getFirst()).intValue());
        return nbt;
    }

    public static Comparator<? super IntAttached<?>> comparator() {
        return (i1, i2) -> Integer.compare((Integer)i2.getFirst(), (Integer)i1.getFirst());
    }

    public static <T> IntAttached<T> read(class_2487 nbt, Function<class_2487, T> deserializer) {
        return IntAttached.with(nbt.method_10550("Location"), deserializer.apply(nbt.method_10562("Item")));
    }
}

